#include <stdio.h>
#include <string.h>

// Define a structure to store student information
struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

int main() {
    // Define an array of structures to store multiple students
    struct Student students[10];

    // Function to input student details
    void inputStudentDetails(struct Student *s) {
        printf("Enter ID: ");
        scanf("%d", &s->id);

        printf("Enter name: ");
        scanf("%s", s->name);

        printf("Enter age (between 18 and 24): ");
        scanf("%d", &s->age);

        printf("Enter address: ");
        scanf("%s", s->address);
    }

    // Function to display details of a student by ID
    void displayStudentById(int id) {
        int i;
        for (i = 0; i < 10; i++) {
            if (students[i].id == id) {
                printf("ID: %d\n", students[i].id);
                printf("Name: %s\n", students[i].name);
                printf("Age: %d\n", students[i].age);
                printf("Address: %s\n", students[i].address);
                return;
            }
        }
        printf("Student with ID %d not found.\n", id);
    }

    // Input details of 10 students
    int i;
    for (i = 0; i < 10; i++) {
        printf("Enter details for student %d:\n", i + 1);
        inputStudentDetails(&students[i]);
    }

    // Get ID from user and display corresponding student details
    int searchId;
    printf("Enter ID of the student you want to search: ");
    scanf("%d", &searchId);
    displayStudentById(searchId);

    return 0;
}
